<?php

namespace App\Controllers;
use App\Models\TenantModel;
use App\Models\UserModel;
use App\Models\MasterConfigModel;
use App\Controllers\BaseController;
use App\Models\LocationModel;
use App\Models\PaymentTypeModel;

class MasterConfigController extends BaseController
{    
    public function __construct()
    {
        $this->UserModel = new UserModel();
        $this->tenants = new TenantModel(); 
        $this->masterconfig = new MasterConfigModel(); 
        $this->LocationsModel = new LocationModel();
        $this->PaymentTypeModel = new PaymentTypeModel();
        $this->now = date("Y-m-d H:i:s");
        helper(['url','form','app','timezone']);
    }
    // insert data
    public function insert()
     {
        $validation = $this->validate([
            'companyname' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter company name',
                ],
            ],
            'address' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter company address',
                ],
            ],
            'contactnumber' => [
                'rules'=>[
                    'required',
                    'regex_match[/^[0-9]{10}$/]',
                    'is_unique[suppliers.SupplierContactNo,SupplierID,{SupplierID}]',
                ],
                'errors'=>[
                    'required'=>'Please enter contact number',
                    'regex_match' => 'Contact Number must be a valid 10-digit mobile number.',
                    'is_unique'=>'This Contact No already exists!',
                ],
            ],
            'currency' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Currancy type',
                ],
            ],
            'btype' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Business type',
                ],
            ],
            'location' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Location',
                ],
            ],
            'loyalty_percentage' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter Loyalty Points',
                ],
            ],
            'loyalty_point_validity_period' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter Loyalty Points',
                ],
            ],
            'tax' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter Tax',
                ],
            ],
            'comment' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please enter Comments',
                ],
            ],
            'tenant_id' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Tenant ID',
                ],
            ],
            'configtype' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Configuration type',
                ],
            ],
            'mlanguage' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'isserialized' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'supplierPaymentTerm' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'storetype' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Store Type',
                ],
            ],
            'payment_type' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select Payment Type',
                ],
            ],
            'backupType' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select backup Type',
                ],
            ],
            'customerPaymentTerm' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'hasOnlineStore' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],
            'hasExpModDate' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Please select value',
                ],
            ],

        ]);
        // echo '<pre>';
        // print_r($this->request->getVar());
        //   die();
        $id = $this->request->getVar('masterID');
        $user_info = getUserInfo();     
        $session = session();
        if($validation){
                if($id == ''){  //insert master config details
            $data = [
                    'company_name' => $this->request->getVar('companyname'),
                    'address' => $this->request->getVar('address'),
                    'contact_number' => $this->request->getVar('contactnumber'),
                    'time_zone' => $this->request->getVar('timezone'),
                    'currency' => $this->request->getVar('currency'),
                    'multi_language' => $this->request->getVar('mlanguage'),
                    'business_type' => $this->request->getVar('btype'),
                    'store_type' => $this->request->getVar('storetype'),
                    'is_serialized' => $this->request->getVar('isserialized'),
                    'customer_payment_term' => $this->request->getVar('customerPaymentTerm'),
                    'supplier_payment_term' => $this->request->getVar('supplierPaymentTerm'),
                    'payment_type' => $this->request->getVar('payment_type'),
                    'backup_type' => $this->request->getVar('backupType'),
                    'has_exp_mod_date' => $this->request->getVar('supplierPaymentTerm'),
                    'loyalty_percentage' => $this->request->getVar('loyalty_percentage'),
                    'loyalty_point_validity_period' => $this->request->getVar('loyalty_point_validity_period'),
                    'has_online_store' => $this->request->getVar('hasOnlineStore'),
                    'type' => $this->request->getVar('configtype'),
                    'tax' => $this->request->getVar('tax'),
                    'Comment' => $this->request->getVar('comment'),
                    'tenant_id' => $this->request->getVar('tenant_id'),
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' => $user_info->UserID,
                    'delete_flag'=>0,
            ];
            $array = $this->request->getVar('location');
            $data['location'] = implode(',',$array); 
            // echo '<pre>';
            // print_r($data);
            //   die();
            $this->masterconfig->insertData($data);
            // Set the success flash message
            $session->setFlashdata('title', 'Saved');
            $session->setFlashdata('message', ' Details saved successfully.');
            }
            else{   //update master config details
                $data = [
                    'company_name' => $this->request->getVar('companyname'),
                    'address' => $this->request->getVar('address'),
                    'contact_number' => $this->request->getVar('contactnumber'),
                    'time_zone' => $this->request->getVar('timezone'),
                    'currency' => $this->request->getVar('currency'),
                    'multi_language' => $this->request->getVar('mlanguage'),
                    'business_type' => $this->request->getVar('btype'),
                    'store_type' => $this->request->getVar('storetype'),
                    'is_serialized' => $this->request->getVar('isserialized'),
                    'customer_payment_term' => $this->request->getVar('customerPaymentTerm'),
                    'supplier_payment_term' => $this->request->getVar('supplierPaymentTerm'),
                    'payment_type' => $this->request->getVar('payment_type'),
                    'backup_type' => $this->request->getVar('backupType'),
                    'has_exp_mod_date' => $this->request->getVar('supplierPaymentTerm'),
                    'loyalty_percentage' => $this->request->getVar('loyalty_percentage'),
                    'loyalty_point_validity_period' => $this->request->getVar('loyalty_point_validity_period'),
                    'has_online_store' => $this->request->getVar('hasOnlineStore'),
                    'type' => $this->request->getVar('configtype'),
                    'tax' => $this->request->getVar('tax'),
                    'Comment' => $this->request->getVar('comment'),
                    'tenant_id' => $this->request->getVar('tenant_id'),
                    'updated_at' => date('Y-m-d H:i:s'),
                    'updated_by' => $user_info->UserID,
                ];
                $array = $this->request->getVar('location');
                $data['location'] = implode(',',$array);  

                // echo '<pre>';
                // print_r($data);
                //   die();
                $this->masterconfig->updateData($id, $data);
                // Set the success flash message
                $session->setFlashdata('title', 'Saved');
                $session->setFlashdata('message', ' Details updated successfully.');
            }
            return $this->response->redirect(site_url('/masterconfig'));
        }
        else{
            $user_info = getUserInfo();
            $tenants = $this->tenants->index();
            $records['masterConfig'] = $this->masterconfig->index();
            $locations['locations'] = $this->LocationsModel->getAllLocations();
            $payment_types=  $this->PaymentTypeModel->index();
            $has_errors = 'true';
            $data = array(
                'breadcrumbs' => 'true',
                'title' => 'MasterConfig',
                'link' => 'masterconfig',
                'tenants' => $tenants,
                'locations' => $locations,
                'userinfo' => $user_info,
                'sources' => $records,
                'validation'=>$this->validator,
                'has_errors' => $has_errors,
                'sources' => $records,
                'locations' => $locations,
                'payment_types' => $payment_types,
            );  
            
            // echo '<pre>';
            // print_r($data);
            //   die();

            return view('masterconfig', $data);
       }
     }
   
    //get single data
    public function singleData($id = null) 
    {
        $data=$this->masterconfig->getSingleData($id);
        if($data){
            echo json_encode(array("status" => true , 'data' => $data));
        }else{
            echo json_encode(array("status" => false));
        }
    }

    public function index()
    {
        $user_info = getUserInfo();
        $tenants = $this->tenants->index();
        $records['masterConfig'] = $this->masterconfig->index();
        $locations['locations'] = $this->LocationsModel->getAllLocations();
        $payment_types=  $this->PaymentTypeModel->index();
        $has_errors = 'false';
        $data = array(
            'breadcrumbs' => 'true',
            'title' => 'MasterConfig',
            'link' => 'masterconfig',
            'tenants' => $tenants,
            'userinfo' => $user_info,
            'has_errors' => $has_errors,
            'sources' => $records,
            'locations' => $locations,
            'payment_types' => $payment_types,
        );
        // echo '<pre>';
        // print_r($records);
        //   die();
     
        return view('masterconfig', $data);
    }

    public function getMasterConfigData()
    {
        $records = $this->masterconfig->indexLocation();
        $jsonString = json_encode($records);
        return $jsonString;
    }
    
    // delete
    public function delete($id = null)
    {
        $user_info = getUserInfo();  
        $data = [
            'deleted_at' =>  $this->now,
            'deleted_by'=>$user_info->UserID,
            'delete_flag' => '1',
        ];
        $this->masterconfig->deleteData($id, $data);
        return $this->response->setJSON([
            'error' => false,
            'message' => 'Successfully deleted!'
        ]);
        return $this->response->redirect(site_url('/banks'));
    } 
}
