<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Suppliers extends Migration
{
    public function up()
    {
        //Create Suppliers Table
        $this->forge->addField([
            'SupplierID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'SupplierImg' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCompanyName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierBRNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierName' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'SupplierNIC' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'SupplierAddressLine1' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierAddresLine2' => [
                'type' => 'varchar',
                'constraint' => 255,
                'null' => true,
            ],
            'payment_term' => [
                'type' => 'int',
            ],
            'SupplierCity' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierProvince' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCountry' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierContactNo' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'SupplierEmail' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'SupplierDescription' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierBankName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierBankACNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'SupplierCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SupplierCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'SupplierUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SupplierUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'SupplierDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'SupplierDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('SupplierID');
        $this->forge->createTable('suppliers');
    }

    public function down()
    {
        //Drop Suppliers Table
        $this->forge->dropTable('suppliers');
    }
}
