<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Stocks extends Migration
{
    public function up()
    {
        //Create stocks table
        $this->forge->addField([
            'StockID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'ItemID' => [
                'type' => 'INT',
            ],
            'BatchNo' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'Unit' => [
                'type' => 'INT'
            ],
            'Qty' => [
                'type' => 'INT'
            ],
            'Price' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'MFDate' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'ExpDate' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'StockCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'StockUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'StockDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'StockDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'StockStatus' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
            ]
        ]);

        $this->forge->addPrimaryKey('StockID');
        $this->forge->createTable('stocks');
    }

    public function down()
    {
        //Drop stocks Table
        $this->forge->dropTable('stocks');
    }
}
