<?php $this->extend('layouts/master') ?>

<?php $this->section('card_promotion') ?>

        <!---List of discount types  --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#cardpromoModel"><i class="bi bi-plus-lg fw-bold"></i> New Card Promotion </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">Bank Name</th>
                                            <th class="p-2" scope="col">Amount</th>
                                            <th class="p-2" scope="col">Started Date</th>
                                            <th class="p-2" scope="col">End Date</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                        <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">     
                                                <td><?php echo $s['BankName']; ?></td>
                                                <td><?php echo $s['amount']; ?></td>
                                                <td><?php echo $s['start_date']; ?></td>
                                                <td><?php echo $s['end_date']; ?></td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="cardPromoedit" type="button" data-bs-toggle="modal" data-bs-target="#cardpromoModel" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="cardPromodelete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- start  card promotion insert and update model  -->
        <div class="modal fade" id="cardpromoModel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel"> Card Promotion Detail Form</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="cardpromo" name="cardpromo" action="<?= site_url('/submit_card_promotion') ?>">
                            <div class="row">
                                <div class="mb-3 col">
                                   <label for="dtype" class="col-form-label">Enter Amount:</label>
                                   <input class="form-control" name="id" id="id" hidden  value="<?php echo set_value('id');?>">
                                    <input type="text" class="form-control" name="amount" id="amount" placeholder="Enter Amount Type">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'amount') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                           <label for="bank" class="col-form-label">Select a Bank:</label>  
                                            <select class="form-control" name="bank" id="bank">
                                               <option value="">Please Select a bank</option> 
                                                <?php
                                                    if ($banks):
                                                    foreach ($banks as $bank):
                                                ?>
                                                        <option <?php echo set_select('bank',  $bank['BID']); ?> value="<?php echo $bank['BID']; ?>"><?php echo $bank['BID']; ?>-<?php echo $bank['BankName']; ?></option>
                                                <?php
                                                   endforeach;
                                               endif;
                                               ?>
                                            </select>
                                            <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'bank') : '' ?></h6>
                                 </div>    
                            </div>  
                            <div class="row">
                               <div class="mb-3 col">
                                    <label for="sdate" class="col-form-label">Enter Started Date:</label>  
                                    <input type="date" class="form-control"  placeholder="Enter start date" value="<?php echo set_value('start_date');?>" name="start_date" id="start_date" >
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'start_date') : '' ?></h6>
                                </div>  
                                <div class="mb-3 col">
                                     <label for="edate" class="col-form-label">Enter End Date:</label>  
                                    <input type="date" class="form-control"   placeholder="Enter end date" value="<?php echo set_value('end_date');?>" name="end_date" id="end_date">
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'end_date') : '' ?></h6>
                                </div>                    
                            </div>      
                            <div class="row">
                                    <div class="mb-3 col">
                                         <label for="supplierdesc" class="col-form-label">Enter remarks:</label> 
                                        <textarea class="form-control" name="remarks" value="<?php echo set_value('remarks');?>" id="remarks" placeholder="Enter remarks"></textarea>
                                        <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'remarks') : '' ?></h6>
                                    </div>
                            </div>           
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold"  id="submit" >Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!---End  card promotion insert and update model ---> 
    </section>
    <?php echo view('includes/footer'); ?>
    <?php
        // Retrieve the flash data
        $session = session();
        $successTitle = $session->getFlashdata('title');
        $successMessage = $session->getFlashdata('message');

        // Check if flash data exists
        if ($successTitle && $successMessage) {
            // Print the success message with seet alert            
            echo "<script>
                    $(document).ready(function() {
                        swal.fire({
                            title: '$successTitle',
                            text: '$successMessage',
                            icon: 'success',
                            showCancelButton: false,
                            confirmButtonText: 'OK',
                        });
                    });
                </script>";
        }
    ?>
    <script>
    function openCardPromoModal(){
            var card_promo_modal = $("#cardpromoModel");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                card_promo_modal.modal('show');
            }
        }
        $(document).ready(function() {
            openCardPromoModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            URTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                URTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    URTable.rows().select();        
                } else {
                    URTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });

        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
        //update card promotion  type
        $('body').on('click', '#cardPromoedit', function () {
            var id = $(this).attr('data-id');
            $.ajax({
                url: 'card_promotion_edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#cardpromoModel').modal('show');
                    $('#cardpromo #id').val(res.data.id); 
                    $('#cardpromo #amount').val(res.data.amount); 
                    $('#cardpromo #bank').val(res.data.bank_name); 
                    $('#cardpromo #start_date').val(res.data.start_date); 
                    $('#cardpromo #end_date').val(res.data.end_date); 
                },
                    error: function (data) {
                }
            });
        });
        //delete  card promotion
                $('body').on('click', '#cardPromodelete', function () {
                var id = $(this).attr('data-id');
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ id).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: '/card_promotion_delete/'+id,
                        async: false,
                        success: function(data){   
                            location.reload()                        
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ id).remove();
                            }
                        }
                    });
                }
            });          
        });

         //start and end date 
         $("body").on("change", "#start_date", function () {
                var myDate = new Date($(this).val());
                var d = new Date(myDate),
                    month = '' + (d.getMonth() + 1),
                    day = '' + d.getDate(),
                    year = d.getFullYear();

                if (month.length < 2) month = '0'+ month;
                if (day.length < 2) day = '0'+day;

                var minDate = [year, month, day].join('-');
                //alert(minDate);
                $("#end_date").attr('min',minDate);
            });
        // prevent multi submit
        document.querySelector('form').addEventListener('submit', function() {
            document.querySelector('#submit').disabled = true;
            });
                    
    </script>
<?php $this->endSection() ?>