<?php $this->extend('layouts/master') ?>

<?php $this->section('pricemanagement') ?>

        <!---List of Customers --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                  <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Select Price</div>
                                            <div class="flex-fill bd-highlight">
                                                <select id="priceMode"  name="priceMode" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                                <option value="" selected>Select an option</option>
                                                <option value="selling"   >Selling price</option>
                                                <option value="purchasing" >Purchasing price</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#addurModal"><i class="bi bi-plus-lg fw-bold"></i> New User Roles </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                  
                                </div> -->
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">ItemId</th>
                                            <th class="p-2" scope="col">ItemName</th>
                                            <th class="p-2" scope="col">Batch Number</th>
                                            <th class="p-2" scope="col">Base Unit</th>
                                            <th class="p-2" scope="col">Price</th>
                                            <th class="p-2 rounded-end" scope="col">Comments</th>
                                        </thead>
                                        <tbody id="tableBody" class="text-primary text-center fw-bold">                                                                                       
                                           
                                        </tbody>
                                    </table>
                                    <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" style="display:none" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submit" >Submit</button>
                                </div>                            
                            </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
       
    </section>
    <?php echo view('includes/footer'); ?>
    <script>
        $(document).ready(function() {
            // $('#priceMode').change();
            // $(this).find('input[name="status"]').val('selling');
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            URTable = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                URTable.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    URTable.rows().select();        
                } else {
                    URTable.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });
        //Check All
        function checkAll(o) {
            var boxes = document.getElementsByClassName("select-checkbox");
            for (var x = 0; x < boxes.length; x++) {
                var obj = boxes[x];
                if (obj.type == "checkbox") {
                if (obj.name != "check")
                    obj.checked = o.checked;
                }
            }
        }                
     
        // populate table row when click on dropdown option
                $('#priceMode').change(function() {
                    var selectedOption = $(this).val();
                    if(selectedOption=='selling'){
                        $('#tableBody').empty();
                    $.ajax({
                        url: '/get_price_detail',
                        method: 'get',
                        dataType: 'json',
                        success: function(records) {
                            console.log(records);
                            // Loop through the records
                            $.each(records, function(index, record) {
                                $( ".dataTables_empty").remove();
                                // Display the record in the container
                                var tableRow = "<tr>";
                                    tableRow += '<td><input type="hidden" class="item_id" readonly name="item_id" value="'+record.ItemID+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="text" class="item_name" readonly name="item_name" value="'+record.ItemName+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="text" class="batch_number" readonly name="batch_number" value="'+record.RBatchNo+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="text" class="base_unit" readonly name="base_unit" value="'+record.UnitName+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="number"   class="selling_price" name="price" value="'+record.RDSellingPrice+'" style="width:85px"></td>';
                                    tableRow += '<td><textarea type="text" class="comment" name="comment"  style="width:150px"></textarea></td>';
                                    tableRow += '<td><input type="hidden" class="receiving_detail_id"  readonly name="receiving_detail_id" value="'+record.RDID+'" style="width:25px"></td>';
                                    tableRow += '<td><input type="hidden" class="status" id="status" value="0" name="status" style="width:85px"></td>';
                                    tableRow += "</tr>";
                                    $("#tableBody").append(tableRow);
                                    $('#submit').show();
                                    setValues();
                            }); 

                            function setValues(){
                            //set ids
                            $('input[class=item_id]').each(function(index, el) {
                            $(this).attr('id',"item_id"+(index+1));
                            });
                            $('input[class=item_name]').each(function(index, el) {
                                $(this).attr('id',"item_name"+(index+1));
                            });
                            $('input[name=batch_number]').each(function(index, el) {
                                $(this).attr('id',"batch_number"+(index+1));
                            });
                            $('input[name=base_unit]').each(function(index, el) {
                                $(this).attr('id',"base_unit"+(index+1));
                            });
                            $('input[name=price]').each(function(index, el) {
                                $(this).attr('id',"selling_price"+(index+1));
                            });
                            $('input[class=comment]').each(function(index, el) {
                                $(this).attr('id',"comment"+(index+1));
                            });
                            $('input[name=receiving_detail_id]').each(function(index, el) {
                                $(this).attr('id',"receiving_detail_id"+(index+1));
                            });
                            $('input[name=status]').each(function(index, el) {
                                $(this).attr('id',"status"+(index+1));
                            });
                           
                            //set selling_price val
                            $('input[class=selling_price]').each(function(index, el) {
                                $(this).change(function(event){
                                    var id= index+1;
                                    var status= "status";
                                    var newId=status+id
                                    console.log(newId);
                                    $("#" + newId).val('1');
                                });
                            });
                           
                        }
                        }
                     });
                    }
                    else{
                        $('#tableBody').empty();
                        $.ajax({
                        url: '/get_price_detail',
                        method: 'get',
                        dataType: 'json',
                        success: function(records) {
                            var container = $('#recordsContainer');
                            // Loop through the records
                            $.each(records, function(index, record) {
                                // Display the record in the container
                                var tableRow = "<tr>";
                                    tableRow += '<td><input type="hidden" readonly name="item_id" value="'+record.ItemID+'" style="width:15px"></td>';
                                    tableRow += '<td><input type="text" readonly name="item_name" value="'+record.ItemName+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="text" readonly name="batch_number" value="'+record.RBatchNo+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="text" readonly name="base_unit" value="'+record.UnitName+'" style="width:85px"></td>';
                                    tableRow += '<td><input type="number" class="purchasing_price"  name="price" value="'+record.RDCostPrice+'" style="width:85px"></td>';
                                    tableRow += '<td><textarea type="text" name="comment"  style="width:150px"></textarea></td>';
                                    tableRow += '<td><input type="hidden" id="receiving_detail_id" readonly name="receiving_detail_id" value="'+record.RDID+'" style="width:25px"></td>';
                                    tableRow += '<td><input type="hidden" class="status" id="status" value="0" name="status" style="width:85px"></td>';
                                    tableRow += "</tr>";
                                    $("#tableBody").append(tableRow);
                                    $('#submit').show();
                                    setValues();
                            });      
                            
                            function setValues(){
                            //set ids
                            $('input[class=item_id]').each(function(index, el) {
                            $(this).attr('id',"item_id"+(index+1));
                            });
                            $('input[class=item_name]').each(function(index, el) {
                                $(this).attr('id',"item_name"+(index+1));
                            });
                            $('input[name=batch_number]').each(function(index, el) {
                                $(this).attr('id',"batch_number"+(index+1));
                            });
                            $('input[name=base_unit]').each(function(index, el) {
                                $(this).attr('id',"base_unit"+(index+1));
                            });
                            $('input[name=price]').each(function(index, el) {
                                $(this).attr('id',"purchasing_price"+(index+1));
                            });
                            $('input[class=comment]').each(function(index, el) {
                                $(this).attr('id',"comment"+(index+1));
                            });
                            $('input[name=receiving_detail_id]').each(function(index, el) {
                                $(this).attr('id',"receiving_detail_id"+(index+1));
                            });
                            $('input[name=status]').each(function(index, el) {
                                $(this).attr('id',"status"+(index+1));
                            });
                           
                            //set purchasing_price val
                            $('input[class=purchasing_price]').each(function(index, el) {
                                $(this).change(function(event){
                                    var id= index+1;
                                    var status= "status";
                                    var newId=status+id
                                    console.log(newId);
                                    $("#" + newId).val('1');
                                });
                            });
                           
                        }
                        }
                     });
                    }                    
                });
              
        //store all table data 
        $('#submit').click(function(e) 
        {
            var tableData = []; // Array to store the table data
            $('#viewtable tbody tr').each(function() {
                    var rowData = {};
                    // Get the input values within the current row
                    var item_id = $(this).find('input[name="item_id"]').val();
                    var item_name = $(this).find('input[name="item_name"]').val();
                    var batch_number = $(this).find('input[name="batch_number"]').val();
                    var base_unit = $(this).find('input[name="base_unit"]').val();
                    var price = $(this).find('input[name="price"]').val();
                    // var purchasing_price = $(this).find('input[name="purchasing_price"]').val();
                    var comment = $(this).find('textarea[name="comment"]').val();
                    var type = $('#priceMode').val();
                    var receiving_detail_id = $(this).find('input[name="receiving_detail_id"]').val();
                    var status = $(this).find('input[name="status"]').val();
                    // Store the input values in an object
                    rowData.item_id = item_id;
                    rowData.item_name = item_name;
                    rowData.batch_number = batch_number;
                    rowData.base_unit = base_unit;
                    rowData.price = price;
                    // rowData.purchasing_price = purchasing_price;
                    rowData.comment = comment;
                    rowData.type = type;
                    rowData.receiving_detail_id = receiving_detail_id;
                    rowData.status = status;
                    
                    // Push the object to the tableData array
                    tableData.push(rowData);
                    console.log(tableData);
                });
                //send table data to save price management table
                $.ajax({
                        url: '/save_price_detail',
                        type: 'POST',
                        data: {
                            tableData: JSON.stringify(tableData)
                        },
                        success: function(response) {
                             swal.fire({
                                title: 'Price Updated  Successfully',
                                text: "",
                                icon: 'warning',
                                showCancelButton: false,
                                icon: 'success',
                                
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    location.reload();
                                }
                                else{
                                }
                            });
                        },
                        error: function(xhr, status, error) {
                            // Handle the AJAX error
                            console.error(error);
                        }
                    });
        });

     
                    
    </script>
<?php $this->endSection() ?>