<?php

namespace App\Models;

use CodeIgniter\Model;

class BanksModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'banks';
    protected $primaryKey       = 'BID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['BankName', 'BCardType', 'BRate', 'BStartingDate', 'BEndingDate', 'BCreatedat', 'BUpdatedAt', 'BDeletedAt','current_status', 'delete_flag','BDeletedBy','BUpdatedBy','BCreatedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'BCreatedat';
    protected $updatedField  = 'BUpdatedAt';
    protected $deletedField  = 'BDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];


    // get all bank data
    function getIndexNBankData()
    {
        $data= $this->db
        ->table('banks')
        ->where('delete_flag', '0')
        ->orderBy('BID ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }

    // get all active bank data
    function getAllActiveIndexNBankData()
    {
        $data= $this->db
        ->table('banks')
        ->where('delete_flag', '0')
        ->where('current_status', '1')
        ->orderBy('BID ', 'ASC')
        ->get()
        ->getResultArray();
        return $data;
    }

    // save bank data
    function insertBankData($data)
	{
        return $this->db
        ->table('banks')
        ->insert($data);
	}

    // get single bank data
    function getSingleBankData($id)
    {
        return $this->db
             ->table('banks')
             ->where(["BID" => $id])
             ->get()
             ->getRow();
    }

    // update bank
    function updateBank($id,$data)
    {
        return $this->db
        ->table('banks')
        ->where(["BID" => $id])
        ->set($data)
        ->update();
    }
    // delete bank
    function deleteBank($id,$data)
    {
        return $this->db
        ->table('banks')
        ->where(["BID" => $id])
        ->set($data)
        ->update();
    }
     //  status  change
     function statusupdate($id,$data)
    {
           return $this->db
               ->table('banks')
               ->where(["BID" => $id])
               ->set($data)
               ->update();
    }

}
