<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'item';
    protected $primaryKey       = 'ItemID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ItemName','ItemImg', 'ItemCategory', 'ItemTags', 'ItemDescription', 'ItemUnit', 'ItemReorderLevel', 'ItemIsSerialized', 'ItemCreatedAt', 'ItemUpdatedAt', 'ItemDeletedAt', 'current_status','delete_flag','ItemUpdatedBy','ItemDeletedBy','ItemCreatedBy'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'ItemCreatedAt';
    protected $updatedField  = 'ItemUpdatedAt';
    protected $deletedField  = 'ItemDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get all Item Data
    function getItemIndexData()
    {
        return $this->db
            ->table('item') 
            ->where('item.delete_flag', 0)
            ->join('itemcategory', 'itemcategory.ICID = item.ItemCategory')
            ->join('units', 'item.ItemUnit = units.UnitID')
            ->orderBy('ItemID ', 'ASC')
            ->select('item.*,itemcategory.ICID,itemcategory.ICName,itemcategory.ICLink,itemcategory.ICParentID,itemcategory.ICParentCatName,units.UnitID,units.UnitName')
            ->get()
            ->getResultArray();
    }

    function getItemActiveIndexData()
    {
        return $this->db
            ->table('item') 
            ->where('item.delete_flag', 0)
            ->where('item.current_status', 1)
            ->join('itemcategory', 'itemcategory.ICID = item.ItemCategory')
            ->join('units', 'item.ItemUnit = units.UnitID')
            ->orderBy('ItemID ', 'ASC')
            ->select('item.*,itemcategory.ICID,itemcategory.ICName,itemcategory.ICLink,itemcategory.ICParentID,itemcategory.ICParentCatName,units.UnitID,units.UnitName')
            ->get()
            ->getResultArray();
    }

    // Insert Item Data
    function insertItemData($data)
    {
        $this->db->table('item')->insert($data);
        return $this->db->insertID();
    }

    // get single item category data
    function getSingleItemData($id)
    {
        return $this->db
            ->table('item')
            ->where('item.ItemID',$id)
            ->join('units', 'units.UnitID = item.ItemUnit','left')
            ->get()
            ->getRow();
    }

    // get single item with unit category data
    function getSingleItemUnitData($id)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID"=> $id])
            ->get()
            ->getResult();
    }
    
    // update item
    function updateItem($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();
    }

    // delete item
    function deleteitem($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();
    }

    // item status & serialize status change
    function statusupdate($id,$data)
    {
        return $this->db
            ->table('item')
            ->where(["ItemID" => $id])
            ->set($data)
            ->update();
    }

    //get item data by item id
    function getItemData($id)
    {
        $item_master_data = $this->db->table('item')->where(["ItemID" => $id])->get()->getRow();
        $item_receiving_data = $this->db->table('stocks')->where(["ItemID" => $id])->get()->getResultArray();
        $item_selling_price_arr_all = [];
        $item_batch_no_arr_all = [];
        $item_qty_on_hand_arr_all = [];
        for($i=0;$i<count($item_receiving_data);$i++){
            array_push($item_selling_price_arr_all,$item_receiving_data[$i]['Price']);
            array_push($item_batch_no_arr_all,$item_receiving_data[$i]['BatchNo']);
            array_push($item_qty_on_hand_arr_all,$item_receiving_data[$i]['Qty']);
        }
        $item_selling_price_arr = array_unique($item_selling_price_arr_all);
        $item_batch_no_arr = array_unique($item_batch_no_arr_all);
        $item_qty_on_hand_arr = $item_qty_on_hand_arr_all;//array_unique($item_qty_on_hand_arr_all);
        $data['item_id'] = $id;
        $data['item_name'] = $item_master_data->ItemName;
        $data['is_serialized'] = $item_master_data->ItemIsSerialized;
        $data['selling_price'] = $item_selling_price_arr;
        $data['batch_no'] = $item_batch_no_arr;
        $data['qty_on_hand'] = $item_qty_on_hand_arr;
        return $data;
    }

    //Receiving Search Bar
    public function searchItems($searchText)
    {
        // Perform the search query based on the search text
        // return $searchText;
        return $this->db
            ->table('item')
            ->like('ItemName', $searchText) // Replace with your column name
            ->get()
            ->getResult();
    }

    //get items base unit
    public function getItemBaseUnit($id)
    {
        return $this->db
            ->table('item')
            ->where('ItemID', $id)
            ->get()
            ->getRow();
    }
}
