<?php

namespace App\Models;

use CodeIgniter\Model;

class SellingPriceModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'selling_price';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['id', 'item_id', 'item_name', 'selling_price','batch_number', 'comment', 'created_at','updated_at','deleted_at','delete_flag','created_by','updated_by','deleted_by'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];



   

    // save selling_price data
    public function insertData($data){
        return $this->db
        ->table('selling_price')
        ->insert($data);
    }

    
    // get single user role data
    function getSingleuRoleData($id){

        return $this->db
             ->table('userrole')
             ->where(["URoleID" => $id])
             ->get()
             ->getRow();

    }


    // update user role data
    function updateUrole($id,$data){

        return $this->db
        ->table('userrole')
        ->where(["URoleID" => $id])
        ->set($data)
        ->update();

    }

   
    // delete user role data
    function deleteUrole($id,$data){
        // die();
        return $this->db
        ->table('userrole')
        ->where(["URoleID" => $id])
        ->set($data)
        ->update();

    }

}
