<?php

namespace App\Models;

use CodeIgniter\Model;

class ShelfModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'shelf';
    protected $primaryKey       = 'ShelfID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['ShelfName', 'RackID', 'ShelfCreaterAt', 'ShelfUpdatedAt', 'ShelfDeletedAt', 'ShelfStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'ShelfCreaterAt';
    protected $updatedField  = 'ShelfUpdatedAt';
    protected $deletedField  = 'ShelfDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];
}
