<?php

namespace App\Controllers;
use App\Models\UserModel;

use App\Controllers\BaseController;

class Auth extends BaseController
{
    public function __construct()
    {
        helper(['url','form']);
    }
    public function index()
    {
        //
        return view('auth/login');
    }

    public function check()
    {
        $validation = $this->validate([
            'username' => [
                'rules'=>'required|is_not_unique[phppos_user.UserName]',
                'errors'=>[
                    'required'=>'User name is required',
                    'is_not_unique'=>'User not exist!',
                ],
            ],
            'password' => [
                'rules'=>'required',
                'errors'=>[
                    'required'=>'Password is required',
                ],
            ],
        ]);     

        if(!$validation){       
            return view('auth/login', ['validation'=>$this->validator]);      
        }
     
        else{
            $username = $this->request->getPost('username');
            $password = $this->request->getPost('password');

            $UserModel = new UserModel();

            $user_info = $UserModel->check($username, $password);
           
            //$p = $user_info['UserPassword'];

            //$check_password = Hash::check($UserPassword, $user_info['UserPassword']);
          //  $user_info = $UserModel->check($username, $password);            
            
            if(!$user_info){
                session()->setFlashdata('Fail', 'Incorrect Password');
                return redirect()->to('/')->withInput();
            }else{ 
                $userid = $user_info['UserID'];
              
                session()->set('loggedUser', $userid);
                return redirect()->to('/index');
            }
        }
    }

    public function logout()
    {
        if(session()->has('loggedUser'))
        {
            session()->remove('loggedUser');
            return redirect()->to('/?access=out')->with('fail', 'You are logged out!');
        }
    }
}
