<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class User extends Migration
{
    public function up()
    {
        //Create User Table
        $this->forge->addField([
            'UserID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'EmpID' => [
                'type' => 'INT',
            ],            
            'UserRole' => [
                'type' => 'INT',
            ],
            'UserName' => [
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'UserPassword' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'AuthKey'=>[
                'type' => 'varchar',
                'constraint' => 255,
                'unique'     => true,
            ],
            'UserCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UserCreatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'UserUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UserUpdatedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'UserDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'UserDeletedBy' => [
                'type' => 'INT',
                'null' => true,
            ],
            'current_status' => [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 1,
                'comment' => 'active: 1,inactive: 2',
            ],
            'delete_flag'=> [
                'type' => 'INT',
                'constraint' => 1,
                'default' => 0,
            ],
        ]);

        $this->forge->addPrimaryKey('UserID');
        $this->forge->createTable('user');
    }

    public function down()
    {
        //Drop User Table
        $this->forge->dropTable('user');
    }
}
