<?php
namespace App\Filters;

use CodeIgniter\Filters\FilterInterface;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use App\Models\UserPermissionModel;
use CodeIgniter\Router\RouteCollection;

class PermissionCheckFilter implements FilterInterface
{
    public function __construct()
    {
        helper(['url','form','app']);
        $this->user_permission_model = new UserPermissionModel();
    }   
    public function before(RequestInterface $request, $arguments = null)
    {
        $permission = $request->uri->getSegment(1); 
        $session = session();
        $session->set('permission', $permission);  
        $user_info = getUserInfo();
        $user = $user_info->UserID;
        $permission_data = $this->user_permission_model->getPermissionDataForUser($user);
        $permissions_list = explode(',', $permission_data);     
        if(session()->has('loggedUser')){
            if(!(in_array($permission, $permissions_list))){
                return redirect()->to('/index');
            }
        }
        else{
            return redirect()->to('/auth')->with('fail', 'You must be Login!');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // Do something here
    }
}