<?php

namespace App\Models;

use CodeIgniter\Model;

class ItemUnitsModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itemunits';
    protected $primaryKey       = 'ItemUnitID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['ItemID', 'OtherUnits','ItemUnitStatus'];

    // Dates
    protected $useTimestamps = false;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    //insert
    function insertItemUnitsData($data)
    {   
        return $this->db
            ->table('itemunits')
            ->insert($data);
    }

    // delete item
    function deleteitemunits($id)
    {
        return $this->db
            ->table('itemunits')
            ->where(["ItemID" => $id])
            ->delete();
    }

    function getSingleItemUnitData($id)
    {
        return $this->db
            ->table('itemunits')
            ->where(["ItemID" => $id])
                ->join('units', 'units.UnitID = itemunits.OtherUnits','left')
            ->get()
            ->getResult();
    }
}
