<?php

namespace App\Models;

use CodeIgniter\Model;

class TempItemSerializedModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'temp_itemserialized';
    protected $primaryKey       = 'id';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = false;
    protected $protectFields    = true;
    protected $allowedFields    = ['CartID', 'RDID', 'item_id', 'receiving_id', 'sale_id', 'serial_number', 'item_status', 'warranty_period', 'is_available_in_stock', 'created_at', 'updated_at', 'deleted_at', 'delete_flag'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'created_at';
    protected $updatedField  = 'updated_at';
    protected $deletedField  = 'deleted_at';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert receiving serial data to db
    function insertSerialData($data)
    {   
        return $this->db
            ->table('temp_itemserialized')
            ->insert($data);
    }

    // get single Rec data
    function getSingleRecSerialData($id)
    {
        return $this->db
            ->table('temp_itemserialized')
            ->where("temp_itemserialized.CartID", $id)
            ->join('temp_receivingdetails', 'temp_receivingdetails.CartID = temp_itemserialized.CartID', 'left')
            ->get()
            ->getResult();
    }

    // get only Receiving Serial Data only
    function getSingleData($id)
    {
        return $this->db
            ->table('temp_itemserialized')
            ->where("CartID", $id)
                //->join('temp_receivingdetails', 'temp_itemserialized.item_id = temp_receivingdetails.ItemID')
            ->get()
            ->getResult();
    }

    // update temp receiving record
    function updateTempRecSerial($id,$data)
    {   //var_dump($data);die();
        return $this->db
            ->table('temp_itemserialized')
            ->where(["CartID" => $id])
            ->set($data)
            ->update();
    }
    
    // insert receiving serial data to db
    function insertSerialDataFromTemp($data)
    {
        return $this->db
            ->table('temp_itemserialized')
            ->insert($data);      
       
    }

    // delete previous data
    public function deletePreviousSerialRecord($id)
    {
        return $this->db->table('temp_itemserialized')->where('CartID', $id)->delete();
    }
}
