<?php

    namespace App\Controllers\Api;

    use CodeIgniter\RESTful\ResourceController;
    use CodeIgniter\API\ResponseTrait;
    use App\Models\InventoryModel;

    class Inventory extends ResourceController
    {
        use ResponseTrait;

        public function index(){            
            $InventoryModel = new InventoryModel();
            $Inventory['Inventory'] = $InventoryModel->orderBy('ItemID', 'DESC')->findAll();
            return $this->respond($Inventory);
        }
        // create item
        public function create() {
            $model = new InventoryModel();
            $data = [
                'ItemCategory' => $this->request->getPost('ItemCategory'),
                'ItemAttrbutes' => $this->request->getPost('ItemAttrbutes'),
                'ItemName' => $this->request->getPost('ItemName'),
                'ItemLabelName' => $this->request->getPost('ItemLabelName'),
                'ItemSupplierID' => $this->request->getPost('ItemSupplierID'),
                'ItemTags' => $this->request->getPost('ItemTags'),
                'ItemManufacturer' => $this->request->getPost('ItemManufacturer'),
                'ItemDescription' => $this->request->getPost('ItemDescription'),
                'ItemWeight' => $this->request->getPost('ItemWeight'),
                'ItemDimention' => $this->request->getPost('ItemDimention'),
                'ItemQty' => $this->request->getPost('ItemQty'),
                'ItemCostPrice' => $this->request->getPost('ItemCostPrice'),
                'ItemSellingPrice' => $this->request->getPost('ItemSellingPrice'),
                'ItemReorderLevel' => $this->request->getPost('ItemReorderLevel'),
                'ItemCurrentQty' => $this->request->getPost('ItemCurrentQty'),
                'ItemImg' => $this->request->getPost('ItemImg'),
                'ItemMFD' => $this->request->getPost('ItemMFD'),
                'ItemEXP' => $this->request->getPost('ItemEXP'),
                'ItemBatchNo' => $this->request->getPost('ItemBatchNo'),
                'ItemIsSerialized' => $this->request->getPost('ItemIsSerialized'),
                'ItemSerialNos' => $this->request->getPost('ItemSerialNos'),
                'ItemEntryDate' => date('m/d/Y h:i:s a'),
                'ItemStatus' => $this->request->getPost('ItemStatus')
            ];
            $model->insert($data);
            $response = [
                'status'   => 201,
                'error'    => null,
                'messages' => [
                    'success' => 'Item added to inventory successfully'
                ]
            ];
            return $this->respondCreated($response);
        } 
        // single item
        public function     ($id = null){
            $model = new InventoryModel();
            $data = $model->where('ItemID', $id)->first();
            if($data){
                return $this->respond($data);
            }else{
                return $this->failNotFound('No Item found in Inventory');
            }
        }
        // update item
        public function update($id = null){
            $model = new InventoryModel();
            $id = $this->request->getVar('ItemID');
            $data = [
                'ItemCategory' => $this->request->getPost('ItemCategory'),
                'ItemAttrbutes' => $this->request->getPost('ItemAttrbutes'),
                'ItemName' => $this->request->getPost('ItemName'),
                'ItemLabelName' => $this->request->getPost('ItemLabelName'),
                'ItemSupplierID' => $this->request->getPost('ItemSupplierID'),
                'ItemTags' => $this->request->getPost('ItemTags'),
                'ItemManufacturer' => $this->request->getPost('ItemManufacturer'),
                'ItemDescription' => $this->request->getPost('ItemDescription'),
                'ItemWeight' => $this->request->getPost('ItemWeight'),
                'ItemDimention' => $this->request->getPost('ItemDimention'),
                'ItemQty' => $this->request->getPost('ItemQty'),
                'ItemCostPrice' => $this->request->getPost('ItemCostPrice'),
                'ItemSellingPrice' => $this->request->getPost('ItemSellingPrice'),
                'ItemReorderLevel' => $this->request->getPost('ItemReorderLevel'),
                'ItemCurrentQty' => $this->request->getPost('ItemCurrentQty'),
                'ItemImg' => $this->request->getPost('ItemImg'),
                'ItemMFD' => $this->request->getPost('ItemMFD'),
                'ItemEXP' => $this->request->getPost('ItemEXP'),
                'ItemBatchNo' => $this->request->getPost('ItemBatchNo'),
                'ItemIsSerialized' => $this->request->getPost('ItemIsSerialized'),
                'ItemSerialNos' => $this->request->getPost('ItemSerialNos'),
                'ItemStatus' => $this->request->getPost('ItemStatus')
            ];
            $model->update($id, $data);
            $response = [
                'status'   => 200,
                'error'    => null,
                'messages' => [
                    'success' => 'Item updated successfully'
                ]
            ];
            return $this->respond($response);
        }
        // delete item
        public function delete($id = null){
            $model = new InventoryModel();
            $data = $model->where('ItemID', $id)->delete($id);
            if($data){-
                $model->delete($id);
                $response = [
                    'status'   => 200,
                    'error'    => null,
                    'messages' => [
                        'success' => 'Item successfully deleted'
                    ]
                ];
                return $this->respondDeleted($response);
            }else{
                return $this->failNotFound('No Item found');
            }
        }
    }
?>