<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class Banks extends Migration
{
    public function up()
    {
        //Create Banks Table
        $this->forge->addField([
            'BID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'BankName' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BCardType' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'BRate' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'BStartingDate' => [
                'type' => 'DATE',
            ],
            'BEndingDate' => [
                'type' => 'DATE',
            ],
            'BCreatedat' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'BStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('BID');
        $this->forge->createTable('banks');
    }

    public function down()
    {
        //Drop Banks Table
        $this->forge->dropTable('banks');
    }
}
