<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ConversionFactor extends Migration
{
    public function up()
    {
        //Create Conversion Factor Table
        $this->forge->addField([
            'CFID' => [
                'type' => 'INT',
                'auto_increment' => true,
            ],
            'FromUnitiD' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'ToUnitID' => [
                'type' => 'varchar',
                'constraint' => 255,
            ],
            'CFFactor' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'CFCreatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'CFUpdatedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'CFDeletedAt' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'CFStatus' => [
                'type' => 'INT',
                'constraint' => 10,
            ],
        ]);

        $this->forge->addPrimaryKey('CFID');
        $this->forge->createTable('conversionfactor');
    }

    public function down()
    {
        //Drop Conversion Factor Table
        $this->forge->dropTable('conversionfactor');
    }
}
