<?php

namespace App\Models;

use CodeIgniter\Model;

class FunctionalityModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'functionalities';
    protected $primaryKey       = 'FID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['FID', 'FName', 'FCreatedAt', 'FUpdatedAt', 'FDeletedAt', 'FStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'FCreatedAt';
    protected $updatedField  = 'FUpdatedAt';
    protected $deletedField  = 'FDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get user role data
    public function getFunctionalitiesIndexData(){

        $data= $this->db
            ->table('functionalities')
            ->where('FStatus', '1')
            ->orderBy('FID', 'ASC')
            ->get()
            ->getResultArray();
        return $data;
    } 
    
    // save employee data
    public function insertFunData($data)
	{      
        return $this->db
                    ->table('functionalities')
                    ->insert($data);
	}
}
