<?php

namespace App\Models;

use CodeIgniter\Model;

class ReceivingSerialDetailModal extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'itemserialized';
    protected $primaryKey       = 'RefID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['RDID', 'RefSerialNos', 'RefComment', 'RefQty', 'RefPrice', 'RefCreatedAt', 'RefUpdatedAt', 'RefDeletedAt', 'RefStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RefCreatedAt';
    protected $updatedField  = 'RefUpdatedAt';
    protected $deletedField  = 'RefDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // insert receiving serial data to db
    function insertSerailData($data)
    {
        return $this->db
            ->table('itemserialized')
            ->insert($data);      
       
    }
}
