<?php

namespace App\Models;

use CodeIgniter\Model;

class SuppliersModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'suppliers';
    protected $primaryKey       = 'SupplierID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['SupplierID', 'SupplierImg', 'SupplierCompanyName', 'SupplierBRNo', 'SupplierName', 'SupplierNIC', 'SupplierAddressLine1', 'SupplierAddresLine2', 'SupplierCity', 'SupplierProvince', 'SupplierCountry', 'SupplierContactNo', 'SupplierEmail', 'SupplierDescription', 'SupplierBankName', 'SupplierBankACNo', 'SupplierCreatedAt', 'SupplierUpdatedAt', 'SupplierDeletedAt', 'SupplierStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'SupplierCreatedAt';
    protected $updatedField  = 'SupplierUpdatedAt';
    protected $deletedField  = 'SupplierDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];



    // get index data
    function getIndexData(){

        $data= $this->db
        ->table('suppliers')
        ->where('SupplierStatus', '1')
        ->orderBy('SupplierID', 'ASC')
        ->get()
        ->getResultArray();

        return $data;
        

    }
 

     // save supplier  data
     function insertSupData($data)
     {
        // echo '<pre>';
        // print_r($data);
        // die();
         return $this->db
                     ->table('suppliers')
                     ->insert($data);
     }

      // get signle employee data
    function getSingleSupData($id){

        return $this->db
             ->table('suppliers')
             ->where(["SupplierID" => $id])
             ->get()
             ->getRow();

    }

    function updateSup($id,$data){

        // echo '<pre>';
        // print_r($data);
        // die();
        return $this->db
        ->table('suppliers')
        ->where(["SupplierID" => $id])
        ->set($data)
        ->update();

    }
    
    
    // delete employee
    function deleteSup($id,$data){
      
        // die();
        return $this->db
        ->table('suppliers')
        ->where(["SupplierID" => $id])
        ->set($data)
        ->update();

    }
}
