<?php

namespace App\Models;

use CodeIgniter\Model;

class UserPermissionModel extends Model
{
    protected $DBGroup          = 'default';
    protected $table            = 'rulebook';
    protected $primaryKey       = 'RBID';
    protected $useAutoIncrement = true;
    protected $insertID         = 0;
    protected $returnType       = 'array';
    protected $useSoftDeletes   = true;
    protected $protectFields    = true;
    protected $allowedFields    = ['RBID', 'RoleID', 'UserID', 'FID', 'RBCreatedAt', 'RBUpdatedAt', 'RBDeletedAt', 'RBStatus'];

    // Dates
    protected $useTimestamps = true;
    protected $dateFormat    = 'datetime';
    protected $createdField  = 'RBCreatedAt';
    protected $updatedField  = 'RBUpdatedAt';
    protected $deletedField  = 'RBDeletedAt';

    // Validation
    protected $validationRules      = [];
    protected $validationMessages   = [];
    protected $skipValidation       = false;
    protected $cleanValidationRules = true;

    // Callbacks
    protected $allowCallbacks = true;
    protected $beforeInsert   = [];
    protected $afterInsert    = [];
    protected $beforeUpdate   = [];
    protected $afterUpdate    = [];
    protected $beforeFind     = [];
    protected $afterFind      = [];
    protected $beforeDelete   = [];
    protected $afterDelete    = [];

    // get user role data
    public function getUPIndexData(){

        $data= $this->db
            ->table('rulebook')
            ->where('RBStatus', '1')
            ->orderBy('RBID', 'ASC')
            ->get()
            ->getResultArray();

        return $data;
    }

    public function insertuPermissionData($data){

        // echo '<pre>';
        // echo 'model';
        // print_r($data);
        // die();
        
        return $this->db
                    ->table('rulebook')
                    ->insert($data);

    }

    
     // get signle employee data
     function getSingleUserPermissionData($id){


        return $this->db
             ->table('rulebook')
            //  ->where(["RBID" => $id])
             ->where('rulebook.RBID',$id)
             ->join('userrole', 'userrole.URoleID = rulebook.RoleID','left')
             ->join('user', 'user.UserID = rulebook.UserID','left')
             ->get()
             ->getRow();

    }


        // update user role data
        function updatePermission($id,$data){

            return $this->db
            ->table('rulebook')
            ->where('rulebook.RBID',$id)
            ->set($data)
            ->update();
    
        }

        
        // delete user role data
    function deleteUserPer($id,$data){
        // die();
        return $this->db
        ->table('rulebook')
        ->where('rulebook.RBID',$id)
        ->set($data)
        ->update();

    }
}

