<?php $this->extend('layouts\master') ?>
<?php $this->section('customer_contact_information') ?>
        <!---List: Start --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Add Category Information</div>
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#insert_modal">
                                                        <i class="bi bi-plus-lg fw-bold"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                       <a href="/items" class="text-secondary text-decoration-none">    
                                                         items
                                                        </a>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                        <th class="p-2" scope="col">ID</th>
                                            <th class="p-2" scope="col">Category Name</th>
                                            <th class="p-2" scope="col">Link</th>
                                            <th class="p-2" scope="col">Created at</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                            ?>
                                            <tr id="<?php echo $s['ICID']; ?>">  
                                                <td><?php echo $s['ICID']; ?></td>  
                                                <td><?php echo $s['ICName']; ?></td>  
                                                <td><?php echo $s['ICLink']; ?></td>  
                                                <td><?php echo $s['ICCreatedAt']; ?></td>
                                                
                                            
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="edit" type="button" data-bs-toggle="modal" data-bs-target="#update_modal" data-id="<?php echo $s['ICID']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="delete" type="button" data-id="<?php echo $s['ICID']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- List: End --->
        <!--- Insert: Start --->
        <div class="modal fade" id="insert_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Item Category</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-3" id="addCategory">
                            <form action="/insertCategoryinfo" method="post" accept-charset="utf-8">
                                <label for="Last-name" class="col-form-label">Add Category</label>
                                <input type="hidden" class="form-control mb-3" name="ICID" id="ICID" placeholder="Enter Category ID">
                                <input type="text" class="form-control mb-3" name="ICName" id="ICName" placeholder="Enter Category Name">
                                <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'ICName') : '' ?></h6>  
                                <select class="form-control mb-3" name="ICParentID" id="ICParentID"> 
                                    <option value="0">Parent ID</option> 
                                    <?php                                        
                                     if($sources):
                                        foreach($sources as $source): 
                                        foreach($source as $s): 
                                    ?>
                                    <option value="<?php echo $s['ICID']; ?>" ><?php echo $s['ICID'].' - '.$s['ICName']; ?></option>                                        
                                   <?php
                                        endforeach;
                                        endforeach;
                                    endif;
                                   ?>                                 
                                </select>
                                <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                            </form>         
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Insert: End --->
        <!--- Update: Start --->
        <div class="modal fade" id="update_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Update Item Category</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row mb-3" id="addCategory">
                            <form action="/updateCategoryinfo" id="updatecat" method="post" accept-charset="utf-8">
                            <input type="text" id="id" name="id"  value="" class="form-control" hidden>
                                <label for="Last-name" class="col-form-label">Add Category</label>
                                <input type="hidden" class="form-control mb-3" name="ICID" id="ICID" placeholder="Enter Category ID">
                                <input type="text" class="form-control mb-3" name="ICName" id="ICName" placeholder="Enter Category Name">
                               
                                <select class="form-control mb-3" name="ICParentID" id="ICParentID"> 
                                    <option value="0">Parent ID</option>  
                                    <?php                                        
                                     if($sources):
                                        foreach($sources as $source): 
                                        foreach($source as $s): 
                                    ?>
                                    <option value="<?php echo $s['ICID']; ?>" ><?php echo $s['ICID'].' - '.$s['ICName']; ?></option>                                        
                                   <?php
                                        endforeach;
                                        endforeach;
                                    endif;
                                   ?>                            
                                </select>
                                <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                            </form>         
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- Update: End --->
    </section>
    <?php echo view('includes/footer'); ?>
    <script>
        function openInsertModal(){
            var insert_modal = $("#insert_modal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                insert_modal.modal('show');
            }
        }
        jQuery(document).ready(function() {
            openInsertModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });
            Table = $('#viewtable').DataTable();
            $('#vtSearch').keyup(function(){
                Table.search($(this).val()).draw() ;
            });
            $(".selectAll").on( "click", function(e) {
                if ($(this).is( ":checked" )) {
                    Table.rows().select();        
                } else {
                    Table.rows().deselect(); 
                }
            });
            $.extend( DataTable.ext.classes, {
                "sPageButton": "page-link btn linear-bg text-secondary fw-bold mx-1 inline p20",                    
                "sWrapper": "row text-center ms-auto me-auto mt-2",                    
                "sFilter": "dnone",
            });
        });                      
        //update
        $('body').on('click', '#edit', function () {
            var id = $(this).attr('data-id');
            $.ajax({
               url: 'item_category_infomation/edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    console.log(res);
                    $('#update_modal').modal('show');
                    $('#updatecat #id').val(res.data.ICID); 
                    $('#updatecat #ICID').val(res.data.ICID); 
                    $('#updatecat #ICName').val(res.data.ICName); 
                   
                    // $('#updatecat #is_default').val(res.data.is_default);
                    // if(res.data.is_default == 1){
                    //     $('#update #is_default_chk').prop("checked", true);
                    // }
                    // if(res.data.is_default == 0){
                    //     $('#update #is_default_chk').prop("checked", false);  
                    // }
                },
                error: function(xhr, status, error) {
                    console.log(res);
                    var err = eval("(" + xhr.responseText + ")");
                    alert(err.Message);
                }
            });
        });
        // delete
        // $('body').on('click', '#delete', function () {
        //     var id = $(this).attr('data-id');
        //     $.get('item_category_infomation/delete/'+id, function (data) {
        //         $('#viewtable tbody #'+ id).remove();
        //     })
        // });  

        $('body').on('click', '#delete', function () {
                var itemCatInfoId = $(this).attr('data-id');
                console.log(itemCatInfoId);
            swal.fire({
		  	    title: 'Are you sure?',
		  	    text: "You won't be able to revert this!",
		  	    icon: 'warning',
		  	    showCancelButton: true,
		  	    confirmButtonText: 'Yes, delete it!',
		    }).then((result) => {
                if (result.isConfirmed) {
                    $('#viewtable tbody #'+ itemCatInfoId).remove();
                    $.ajax({
                        type: 'GET',
                        dataType: 'json',
                        url: 'item_category_infomation/delete/'+itemCatInfoId,
                        async: false,
                        success: function(data){                      
                            swal.fire({
                                icon: data.icon,
                                title: data.title,
                                text: data.message,
                            });
                            if(data['status'] == 'true'){
                                $('#viewtable #'+ itemCatInfoId).remove();
                            }
                        }
                    });
                }
            });          
        });
          //reset form
          $('#insert_modal').on('hidden.bs.modal', function (e) {
            // Clear the form fields
            $(this).find('form').trigger('reset');
             $(this).find('.text-danger').remove();
            });
    </script>
<?php $this->endSection() ?>