<?php $this->extend('layouts\master') ?>

<?php $this->section('receivings') ?>
    <!--- Sale Status --->       
    <div class="container-fluid mt-3">
        <?php $validation = \Config\Services::validation(); ?>
    
        <form method="post" id="recForm" enctype="multipart/form-data"  accept-charset="utf-8">
               
            <div class="row">
                <div class="col-8">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 me-3 ms-1 bill-area">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">Receiving Mode </div>
                                            <div class="flex-fill bd-highlight">
                                                <select id="recMode" name="mode" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                                    <option selected>Select receive mode</option>
                                                    <option value="1">Receive</option>
                                                    <option value="2">Return</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="subtitle-line bg-secondary ms-auto me-auto ml-1 mt-2">
                                    <div class="d-flex bd-highlight ">
                                        <div class="flex-fill bd-highlight">Find/Scan Item </div>
                                        <div class="flex-fill bd-highlight">                                      
                                            <select id="dropdown" class="form-select ms-2 py-0 text-primary fw-bold" aria-label="Default select example">
                                                <option  selected>Start Typing item's name</option>                                               
                                                <?php
                                                    if ($sources):
                                                    foreach ($sources as $source):
                                                ?>
                                                        <option value="<?php echo $source['ItemID']; ?>"><?php echo $source['ItemID']; ?>-<?php echo $source['ItemName']; ?></option>
                                                <?php
                                                   endforeach;
                                               endif;
                                               ?>
                                            </select>
                                        </div>
                                        <div class="ps-4 py-0 text-primary fw-bold">
                                            <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#userdteModal">
                                                <i class="bi bi-upc-scan"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">New Item</div>
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#itemAddModel">
                                                        <i class="bi bi-plus-lg fw-bold"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table">
                                <div class="tableFixHead mt-2"> 
                                    <table class="table rounded align-middle" id="viewtable">
                                        <thead class="text-center text-secondary rounded">
                                            <!-- <th class="rounded-start" scope="col">Delete</th> -->
                                            <!--th scope="col" id="itemId">Item#</th-->
                                            <th scope="col" id="itemId">Item Name</th>
                                            <!--th scope="col">serial</th-->
                                            <th scope="col">EXD</th>
                                            <th scope="col">MFD</th>
                                            <th scope="col">Cost</th>
                                            <th scope="col">Selling</th>
                                            <th scope="col">Qty</th>
                                            <th scope="col">Disc %</th>
                                            <!--th scope="col"></th-->
                                            <th scope="col">Total</th>
                                            <th scope="col" style="display:none" >ramont</th>
                                            <th class="rounded-end" scope="col">Action</th>
                                            <!-- <th class="rounded-end" scope="col">Delete</th> -->
                                        </thead>
                                        <tbody id="table_body" class="text-primary fw-bold">
                                       
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-4">                    
                    <div class="linear-bg rounded-15 p-2">
                        <div class="d-flex bd-highlight mb-1">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">Select Supplier (Optional)</div>
                                        <div class="flex-fill bd-highlight">
                                            <select name="supplier" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                                <?php
                                                    if ($Suppliers):
                                                        foreach ($Suppliers as $Supplier):
                                                ?>
                                                            <option value="<?php echo $Supplier['SupplierID']; ?>"><?php echo $Supplier['SupplierID']; ?>-<?php echo $Supplier['SupplierName']; ?></option>
                                                <?php
                                                        endforeach;
                                                    endif;
                                                ?>
                                            </select>                                            
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">New Supplier</div>
                                        <div class="flex-fill bd-highlight">
                                            <div class="ms-2 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#supplierdteModal">
                                                    <i class="bi bi-plus-lg fw-bold"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Subtotal</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0" ><input type="text" class="mainform" name="subtot"id="subtot"></td>
                                    </tr>
                                    <tr class="mt-3">
                                        <td class="py-0">3.00% Sales Tax:</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" value="90" class="mainform" id="stax1" name="tax3"></td>                                        
                                    </tr>                                    
                                    <tr class="mt-3">
                                        <td class="py-0">5.00% Sales Tax 2:</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" class="mainform" value="4" id="stax2" name="tax5"></td>
                                    </tr>
                                    <tr class="mt-3">
                                        <td class="py-0">Total</td>
                                        <td class="text-end py-0">Rs</td>
                                        <td class="py-0"> <input type="text" class="mainform" name="tot" id="tot"></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="bill-box rounded-15 bg-secondary p-1 mt-3">
                            <table class="table table-borderless my-0">
                                <tbody class="text-primary fw-bold ">
                                    <tr>
                                        <td class="py-0">Comments</td>
                                        <td class="text-end py-0">
                                            <input type="text" id="rcomment" name="comments" class="mainform">
                                            <?php if($validation->getError('name')) {?>
                                                <div class='alert alert-danger mt-2'>
                                                <?= $error = $validation->getError('comments'); ?>
                                                </div>
                                            <?php }?>                                         
                                        </td>                                        
                                    </tr>                                    
                                </tbody>
                            </table>
                        </div>
                        <div class="flex-fill bd-highlight">
                            <div class="subtitle-line bg-secondary ml-1 mt-3 mb-1 ">
                                <div class="d-flex bd-highlight">
                                    <div class="flex-fill bd-highlight">Payment type</div>
                                    <div class="flex-fill bd-highlight">
                                        <select id="paytype" name="payType" class="form-select ms-2 py-0 text-primary fw-bold mainform" aria-label="Default select example">
                                            <option Selected>Select payment type</option>
                                            <option value="1">credit</option>
                                            <option value="2">cash</option>                                        
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" name="ramount" id="ramount">
                        <input type="hidden" name="recMode" id="recMode" class="recModeclass">
                        <input type="hidden" name="userId" value="<?php echo $userinfo->UserID; ?>">                               

                        <div class="d-flex bd-highlight mb-1 mt-2">
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <!-- <div class="" style="width:50px; height:50px; background-color:red" id="recivingDone">click check value </div> -->
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="submit" id="recivingDone">
                                                Finish 
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="flex-fill bd-highlight">
                                <div class="subtitle-line bg-secondary ml-1 mt-1 mb-1 ms-auto">
                                    <div class="d-flex bd-highlight">
                                        <div class="flex-fill bd-highlight">
                                            <button class="btn linear-bg text-secondary px-2 py-0 employeeEditCls" type="button" data-bs-toggle="modal" data-bs-target="#employeeUpdate" data-id=""  id="employeeEdit">
                                                Cancel
                                            </button>
                                        </div>                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>                   
                </div>
            </div>
        </form>   
    </div>
    <!--- Item Module --->
    <form id="newRecItemAdd" method="post" enctype="multipart/form-data" accept-charset="utf-8">
        <div class="modal fade" id="itemAddModel" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Add New Item</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemName" name="ItemName" placeholder="Enter Item Name">
                            </div>                                
                            <div class="mb-3 col">
                                <select class="form-control" name="ItemCategory" id="ItemCategory">
                                    <?php                                        
                                        if($ItemCategories):
                                        foreach($ItemCategories as $ItemCategory):
                                    ?>                                        
                                    <option value="<?php echo $ItemCategory['ICID']; ?>" ><?php echo $ItemCategory['ICName']; ?></option>
                                    
                                    <?php
                                        endforeach;
                                        endif;
                                    ?>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemTags" name="ItemTags" placeholder="Enter Item Tags">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemDescription" name="ItemDescription" placeholder="Enter Item Description">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemUnit" name="ItemUnit" placeholder="Enter Item Unit" />
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="ItemReorderLevel" name="ItemReorderLevel" placeholder="Enter Item Reorder Level">
                            </div>
                        </div>
                        <div class="row">
                            <div class="wrapper col">
                                <div class="box">
                                    <div class="js--image-preview">
                                        <img id="design"  class ="" alt="Ad Picture"  style="width:auto; height:100px;"/>
                                    </div>
                                    <div class="upload-options">
                                        <label>
                                            <input type="file" class="image_upload" accept="image/*" name="ItemImg" id="ItemImg ">
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col"> 
                                <input class="form-check-input" name="ItemIsSerialized" type="checkbox" value="1" id="ItemIsSerialized">
                                <label class="form-check-label ms-1" for="flexCheckDefault"> : Item Is Serialized </label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer ">
                        <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button> -->
                        <div class="d-flex align-items-start">
                            <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submitRecItemBtn">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
    <!--- Item Module End--->

    <!--- Supplier Module --->
    <div class="modal fade" id="supplierdteModal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header linear-bg">
                    <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">New Supplier</h5>
                    <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="first_name" placeholder="Enter First Name">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="last_name" placeholder="Enter Last Name">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="email" class="form-control" id="email" placeholder="Enter Email">
                            </div>
                            <div class="mb-3 col">
                                <input type="phone" class="form-control" id="phone_number" placeholder="Enter Phone Number">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Address_1" placeholder="Enter Address 1">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Address_2" placeholder="Enter Address 2">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="city" placeholder="Enter City">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="state" placeholder="Enter State">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="zip" placeholder="Enter Zip code">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Country" placeholder="Enter Country">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="recipient-name" placeholder="Account #">
                            </div>
                            <div class="mb-3 col">
                                <input type="text" class="form-control" id="Company" placeholder="Enter Company Name">
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3 col">
                                <textarea class="form-control" id="message-text" placeholder="Enter Comments"></textarea>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="modal-footer ">
                    <button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                </div>
            </div>
        </div>
    </div>
    <!--- Supplier Module End--->

    <!--- Sale Status End --->
    <!-- new item serialize form -->
    <form id="newSerItemDetailAdd" method="post" enctype="multipart/form-data" accept-charset="utf-8">
        <!-- <div class="modal fade" id="newitemserialized" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true"> -->
        <div class="modal fade" id="newitemserialized">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Item Serialized Details</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body" id="serializeditemtable">
                        <form id="serialForm" method="GET">
                            <div class="row">
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="RefSerialNos" name="RefSerialNos" placeholder="Enter serialized number">
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="RefComment" name="RefComment" placeholder="Enter comments">
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="RefQty" name="RefQty" placeholder="Enter Item quantity" />
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="RefCostPrice" name="RefCostPrice" placeholder="Enter Cost price">
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="RefSellPrice" name="RefsellPrice" placeholder="Enter Selling price">
                                </div>
                                <div class="mb-3 col">
                                    <input type="text" class="form-control" id="RefTotal" name="RefTotal">
                                </div>
                                <button type="button" class="btn linear-bg text-secondary" id="addanotherrow" style="margin-right: 10px;width: 3%; height: 5%;padding: 0;margin-top:5px;"><i class="bi bi-plus-lg fw-bold"></i></button>
                            </div>
                        </form>
                    </div>
                    <div class="modal-footer ">
                        <div class="d-flex align-items-start">
                            <button type="button" class="btn linear-bg text-secondary px-2 py-2 fw-bold" id="submitSerialDetailBtn">Submit</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
</section>
<?php echo view('includes/footer'); ?>
    <script>
        $(document).ready(function() {
            // get serial data to table input
            var serialNos = null;
            var groupedSerialData = [];
            $('#submitSerialDetailBtn').on('click', function(event){
                event.preventDefault();
                serialNos = $('#serializeditemtable input').map(function(index, element) {
                    return {
                        Name: $(element).attr('name'),                        
                        Value: $(element).val()
                    }
                }).get();
                //console.log(serialNos);
                $.map(serialNos, function(element, index) {
                    var groupSerialIndex = Math.floor(index / 4);

                    if (groupedSerialData[groupSerialIndex] === undefined) {
                        groupedSerialData[groupSerialIndex] = [];
                    }
                    
                    groupedSerialData[groupSerialIndex].push(element);
                });
                // serial data stored in groupedSerialData
                //console.log(groupedSerialData);
                //$('#serial').val(groupedSerialData);
                $("#newSerItemDetailAdd")[0].reset();
                $("#newitemserialized input").val('');
                $("#newitemserialized").modal("hide");

            });
            //console.log(groupedSerialData);

            $('#serialItemPopUp').on('click', function(){
                $("#newitemserialized").modal("show");
                //console.log('1');                
            });
            
            // if(groupedSerialData != ''){
            //     console.log(groupedSerialData);
            // }

            // add row in serialized item modal
            $('#addanotherrow').click(function() {
                // create a new row with two input fields
                var newRow = $('<div class="row">');
                var serailNoInput = $('<input class="form-control" id="RefSerialNos" name="RefSerialNos">').attr({type: 'text'});
                var commentInput = $('<input class="form-control" id="RefComment" name="RefComment">').attr({type: 'text'});
                var QtyInput = $('<input class="form-control" id="RefQty" name="RefQty">').attr({type: 'text'});
                var PriceInput = $('<input class="form-control" id="RefCostPrice" name="RefCostPrice">').attr({type: 'text'});
                var PriceInput = $('<input class="form-control" id="RefSellPrice" name="RefSellPrice">').attr({type: 'text'});
                var PriceInput = $('<input class="form-control" id="RefTotal" name="RefTotal">').attr({type: 'text'});
                //var DeleteButton = $('<button class="btn secondary-bg text-primary" id="deleterow" style="margin-right: 10px;width: 3%; height: 5%;padding: 0;margin-top:5px;"><i class="bi bi-dash fw-bold"></i></button>').attr({type: 'button'});
                newRow.append($('<div class="mb-3 col">').append(serailNoInput));
                newRow.append($('<div class="mb-3 col">').append(commentInput));
                newRow.append($('<div class="mb-3 col">').append(QtyInput));
                newRow.append($('<div class="mb-3 col">').append(PriceInput));
                //newRow.append($('').append(DeleteButton));

                // add the new row to the table
                $('#serializeditemtable').append(newRow);
            });
            // $('body').on('submit', '#recForm', function(e) {
            //     e.preventDefault();
            //     var myArray = [];
            //     $('.mainform').each(function() {
            //         myArray.push($(this).val());
            //     });

            //     console.log(myArray);
            // });
            const dropdown=document.getElementById('dropdown');
            var tableBody= document.getElementById('table_body');
            const recMode=document.getElementById('recMode');

            // select receiving mode     
            recMode.addEventListener('change', ()=>{
                var recVal= recMode.value;
                //console.log('recVal'+ recVal)
                $(".recModeclass").val(recVal)
            });

            // add alreday database items
            dropdown.addEventListener('change', ()=>{

                const selectedOption=dropdown.value;
        
                var itemId = selectedOption;
                //alert(itemId);
                $.ajax({
                    url: 'receivings/feeditemdata/'+itemId,
                    type: "GET",
                    dataType: 'json',
                    success: function (data) { 
                        //console.log(data);                                   
                        var trHTML1 = '';
                        var trHTML2 = '';
                        var total=0;
                        var ramount=0;
                        var sum=0;
                        $.each(data, function (i, item) {
                            // console.log(item.ItemIsSerialized); 
                            //<td class="nr">' +item.ItemID +    
                            //'</td>

                            //<td >' 
                            //+'<input type="hidden" style="width:35px" class="serial" id="serial" value="1">'+
                             //       '</td>

                            //  <td>'
                            //         +'<input type="hidden" id="totramount" style="width:15px" placeholder="ramount" value="'+ramount+'" class="ramount">'+
                            //         '</td>
                            // <td>' 
                            //         + '<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+item.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'+
                            //         '</td>
                            trHTML1 += 
                                '<tr id="'+item.ItemID+'">'
                                    +'<td id="itemName"><a href="#" class="btn linear-bg text-secondary px-2 py-0" id="serialItemPopUp" type="button" data-bs-toggle="modal" data-bs-target="#newitemserialized">' + item.ItemName +'</a>'
                                    +'<input type="hidden" class="serial" id="serial" value="1"></td><td>' 
                                    +'<input type="date" name="mandate" class="manDate" id="rmanDate">'+
                                    '</td><td>'                                             
                                    +'<input type="date" name="expdate" class="expmanDate" id="rexpDate">'+
                                    '</td><td>'
                                    + '<input type="text" value="0.00" class="reciveprice" id="rItemPrice" style="width:35px">'+ 
                                    '</td><td>'
                                    + '<input type="text" value="0.00" class="recivesellingprice" id="rItemPrice" style="width:35px">'+ 
                                    '</td><td>' 
                                    + '<input type="text" style="width:35px" class="quantity" id="rItemqty" value="1">'+ 
                                    '</td><td>'
                                    + '<input type="text" class="discount"style="width:35px" id="rItemDiscount">'+ 
                                    '</td><td>' 
                                    +'<input type="text" id="rtotal" value="'+total+'" style="width:80px" class="rtotal">'+
                                    '</td><td>' + 
                                    '<button class="btn linear-bg text-secondary px-2 py-0" id="calitemtotal" data-value="'+item.ItemID+'" ><i class="bi bi-check-square-fill"></i></button> | <button class="btn linear-bg text-secondary px-2 py-0" data-id="'+item.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'                                
                                    + '</td></tr>';                  
                            
                            //<td class="nr">' +item.ItemID +   
                            //'</td>
                            //<td>' 
                            //+'<input type="hidden" style="width:35px" class="serial" id="serial" value="0" >'+
                              //  '</td>

                            //   <td>'
                            //     + '<input type="hidden" id="totramount" style="width:15px" placeholder="ramount" value="'+ramount+'" class="ramount">'+
                            //     '</td>

                            // <td>' 
                            //     + '<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+item.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'+
                            //     '</td>
                            trHTML2 += 
                                '<tr id="'+item.ItemID+'"><td id="itemName">' + item.ItemName 
                                +'<input type="hidden" class="serial" id="serial" value="0" ></td><td>' 
                                +'<input type="date" name="mandate" class="manDate" id="rmanDate">'+
                                '</td><td>' 
                                +'<input type="date" name="expdate" class="expmanDate" id="rexpDate">'+
                                '</td><td>'
                                + '<input type="text" value="0.00" class="reciveprice" id="rItemCostPrice" style="width:35px">'+ 
                                '</td><td>'
                                + '<input type="text" value="0.00" class="recivesellingprice" id="rItemSellPrice" style="width:35px">'+ 
                                '</td><td>' 
                                + '<input type="text" style="width:35px" class="quantity" id="rItemqty" value="1">'+ 
                                '</td><td>'
                                + '<input type="text" class="discount"style="width:35px" id="rItemDiscount">'+ 
                                '</td><td>' 
                                +'<input type="text" id="rtotal" value="'+total+'" style="width:80px" class="rtotal">'+                                
                                '</td><td>' +
                                '<button class="btn linear-bg text-secondary px-2 py-0" id="calitemtotal" data-value="'+item.ItemID+'" ><i class="bi bi-check-square-fill"></i></button> | <button class="btn linear-bg text-secondary px-2 py-0" data-id="'+item.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'                                
                                + '</td></tr>';                                
                                
                            if(item.ItemIsSerialized == 1){
                                //tableBody=trHTML1;
                                //$('#table_body').html(trHTML1);
                                $("#table_body").append(trHTML1);
                                //alert(tableBody);
                            }else{
                                //tableBody=trHTML2;
                                //$('#table_body').html(trHTML2);
                                $("#table_body").append(trHTML2);
                            }
                            $(".rtotal").each(function(){
                                sum += parseInt($(this).closest("tr").find(".rtotal").val());
                                $("#subtot").val(sum);                                                  
                                var netTax= parseInt($("#stax1").val())+parseInt($("#stax2").val());
                                var tot=parseInt($("#subtot").val())-netTax;
                                $("#tot").val(tot);
                            });

                            $(".ramount").each(function(){
                                ramount += parseInt($(this).closest("tr").find(".ramount").val()); 
                                $("#ramount").val(ramount);
                            });                               
                        });
                    },                                  
                    error: function (data) {
                        //console.log('error');
                    }
                });
            });

            //delete receiving record from data table
            $('body').on('click', '#recDel', function () {
                var RecId = $(this).attr('data-id');
                var delVal=parseInt($(this).closest("tr").find(".rtotal").val());
                var totVal=parseInt($("#subtot").val())-(parseInt($("#stax1").val())+parseInt($("#stax2").val()));
                var subtotVal=parseInt($("#subtot").val());
                var newVal=totVal-delVal;
                var newsubTotVal=subtotVal-delVal;
                //console.log(newVal);
                $("#tot").val(newVal);
                $("#subtot").val(newsubTotVal);
                $(this).closest('tr').remove();           
            });  
            
            // add new item to system   
            $('#submitRecItemBtn').on('click', function(e) {
                //   console.log($('#newRecItemAdd').serialize());
                e.preventDefault();
                var formData = $('#newRecItemAdd').serialize();
                //console.log(formData);
                $.ajax({
                    type: 'POST',
                    url: '/itemsaveandrec', // replace with the actual URL that handles the form submission
                    data: formData,
                    dataType: 'json',
                    success: function(res) {
                        //console.log(res.data);
                        $('#itemAddModel').modal('hide');
                        var id = res.data.ItemID;
                        var name = res.data.ItemName;
                        var price = res.data.ItemCostPrice;

                        // create a new row in the table and populate it with the data
                        var newRow1 = $("<tr>");
                        newRow1.append($("<td>").text(id));
                        newRow1.append($("<td>").html('<a href="#" class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#newitemserialized" id="itemName">'+name+'</a>'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="1" class="serial" id="serial">'));
                        newRow1.append($("<td>").html('<input type="date" class="expDate" id="rexpDate">'));
                        newRow1.append($("<td>").html('<input type="date" class="manDate" id="rmanDate">'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="price" id="pricenew">'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="sellprice" id="sellpricenew">'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="1" class="quantity" id="qtynew">'));
                        newRow1.append($("<td>").html('<input type="text" class="discount" style="width:35px" id="discnew">'));
                        newRow1.append($("<td>").html('<input type="hidden" id="rnewamountid" class="ramount">'));
                        newRow1.append($("<td>").html('<input type="text" id="totalnewadd" style="width:80px" value="0" class="rtotal">'));
                        newRow1.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0 getIdnewadd" id="'+res.data.ItemID+'" data-value="'+res.data.ItemID+'"><i class="bi bi-check-square-fill"></i></button>'));
                        newRow1.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+res.data.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'));              

                        var newRow2 = $("<tr>");
                        newRow2.append($("<td>").text(id));
                        newRow2.append($("<td>").text(name));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="0" class="serial" id="serial">'));
                        newRow2.append($("<td>").html('<input type="date" class="expDate" id="rexpDate">'));
                        newRow2.append($("<td>").html('<input type="date" class="manDate" id="rmanDate">'));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="price" id="pricenew">'));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="sellprice" id="sellpricenew">'));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="1" class="quantity" id="qtynew">'));
                        newRow2.append($("<td>").html('<input type="text" class="discount" style="width:35px" id="discnew">'));
                        newRow2.append($("<td>").html('<input type="hidden" id="rnewamountid" class="ramount">'));
                        newRow2.append($("<td>").html('<input type="text" id="totalnewadd" style="width:80px" value="0" class="rtotal">'));
                        newRow2.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0" id="'+res.data.ItemID+'" data-value="'+res.data.ItemID+'"><i class="bi bi-check-square-fill"></i></button>'));
                        newRow2.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+res.data.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'));
                
                        // // append the new row to the table
                        if(res.data.ItemIsSerialized==1){
                            $("#viewtable").append(newRow1);  
                        }else{
                            $("#viewtable").append(newRow2);
                        }                   
                    
                        // $('.getIdnewadd').click(function(e){
                        //     e.preventDefault();
                        //     var id = $(this).attr('id');
                        //     console.log(id);
                        //     var total=0;
                        //     var price = $("#pricenew").val();
                        //     var qty = $("#qtynew").val();
                        //     var disc = $(this).closest('tr').find('#discnew').val();

                        //     var ramount=price*qty;
                        //     $(this).closest('tr').find('.ramount').val(ramount);

                        //     if(qty>=1){
                        //         // alert(total);
                        //         if( disc){
                        //             var total= price*qty;
                        //             var disc=(total*disc)/100;
                        //             var totalwithdisc=total-disc;
                        //             total=totalwithdisc;
                        //             // alert('qty+disc'+total);
                        //         }else{
                        //             table=trHTML2;
                        //         }
                        //     }
                        // });
                                    
                        $('#viewtable').append(table);
                    
                        // $('.getId').click(function(e){
                        //     e.preventDefault();
                        //     var id = $(this).attr('id');
                        //     console.log(id);
                        //     var total=0;
                        //     var price = $(this).closest('tr').find(".reciveprice").val();
                        //     var qty = $(this).closest('tr').find(".quantity").val();
                        //     var disc = $(this).closest('tr').find(".discount").val();
                                                        
                        //     var ramount=price*qty;
                        //     $(this).closest('tr').find('.ramount').val(ramount);
                        //     if(qty){                                
                        //         // alert(total);
                        //         if( disc){
                        //             var total= price*qty;
                        //             var disc=(total*disc)/100;
                        //             var totalwithdisc=total-disc;
                        //             total=totalwithdisc;
                        //             // alert('qty+disc'+total);
                        //         }
                        //         else{
                        //             var total= price*qty;
                        //             //  alert('no disc, have qty'+total);
                        //         }
                        //         // alert(total);                                        
                        //     }else{
                        //         if(disc){                                                
                        //             var disc=(price*disc)/100;
                        //             var totalwithdisc=price-disc;
                        //             total=totalwithdisc;
                        //             //  alert('no qty have disc'+total);
                        //         }else{
                        //             var total= price;
                        //             //  alert('no qty no disc'+total);
                        //         }                                    
                        //         //alert(total);
                        //     }                        
                        //     var val= $(this).closest('tr').find('.rtotal').val(total);
                            
                        //     var sum = 0;
                        //     var ramount = 0;
                                            
                        //     $(".rtotal").each(function(){
                        //         sum += parseInt($(this).closest("tr").find(".rtotal").val());
                        //         $("#subtot").val(sum);                                                  
                        //         var netTax= parseInt($("#stax1").val())+parseInt($("#stax2").val());
                        //         var tot=parseInt($("#subtot").val())-netTax;
                        //         $("#tot").val(tot);
                        //     });

                        //     $(".ramount").each(function(){
                        //         ramount += parseInt($(this).closest("tr").find(".ramount").val()); 
                        //         $("#ramount").val(ramount);
                        //     });
                        // });
                                                          
                    },                                    
                    error: function (data) {
                        //console.log('error');
                    }
                });
            });

            // subtotal, total calculation
            $('body').on('click', '#calitemtotal', function(e){
                e.preventDefault();
                var rowCount = $("#viewtable tr").length;
                var id = $(this).data('value');
                var total=0;
                var costprice = $(this).closest('tr').find("#rItemCostPrice").val();
                var qty = $(this).closest('tr').find("#rItemqty").val();
                var disc = $(this).closest('tr').find("#rItemDiscount").val();
                                            
                var ramount = costprice*qty;
                if(disc){
                    var total = ramount - (ramount * (disc/100));
                    $(this).closest('tr').find('#rtotal').val(parseInt(total));
                }else{                    
                    $(this).closest('tr').find('#rtotal').val(parseInt(ramount));
                }

                var sum = 0;
                $(".rtotal").each(function(){
                    sum += parseInt($(this).closest("tr").find(".rtotal").val());
                    $("#subtot").val(sum);  
                    console.log(sum);                                                
                    var netTax = parseInt($("#stax1").val()) + parseInt($("#stax2").val());
                    var tot = parseInt($("#subtot").val()) - netTax;
                    $("#tot").val(tot);
                });
            });

            //delete receiving record from data table
            $('body').on('click', '#recDel', function () {
                var RecId = $(this).attr('data-id');
                var delVal=parseInt($(this).closest("tr").find(".rtotal").val());
                var totVal=parseInt($("#subtot").val())-(parseInt($("#stax1").val())+parseInt($("#stax2").val()));
                var subtotVal=parseInt($("#subtot").val());
                var newVal=totVal-delVal;
                var newsubTotVal=subtotVal-delVal;
                //console.log(newVal);
                $("#tot").val(newVal);
                $("#subtot").val(newsubTotVal);
                $(this).closest('tr').remove();           
            }); 

            var tableData = [];

            // pass table data to controller
            $('body').on('submit', '#recForm', function(e) {
                e.preventDefault();
                $('#viewtable tbody tr').each(function(row, tr){                        
                    tableData[row] ={
                        "id" : $(tr).find('td:eq(0)').text(),
                        "name" : $(tr).find('td:eq(1)').text(),
                        "serialized" : $(tr).find('.serial').val(),
                        "expDate" : $(tr).find('td:eq(3)').text(),
                        "manDate" : $(tr).find('td:eq(4)').text(),
                        "price" : $(tr).find('.reciveprice').val(),
                        "qty" : $(tr).find('.quantity').val(),
                        "total" : $(tr).find('.rtotal').val(),
                    }; 
                    //console.log(tableData);
                });
                
                var frmData = $("#recForm").serialize();
                
                //console.log(frmData);
                $.ajax({
                    // alert(rowData);
                    url: '/recevingfinish',
                    type: "POST",
                    data: { 
                        tableData: tableData,
                        frmData:frmData,
                        groupedSerialData:groupedSerialData,
                    },
                    //dataType: "json",
                    success: function(response) {
                        //console.log(frm_data);
                        //console.log(response);
                    },
                    error: function(xhr) {
                        console.error('Error saving table data:', xhr.responseText);
                        //console.log(frm_data);
                    }
                });
            });     
            
            // add new item to system   
            $('#submitRecItemBtn').on('click', function(e) {
                //   console.log($('#newRecItemAdd').serialize());
                e.preventDefault();
                var formData = $('#newRecItemAdd').serialize();
                //console.log(formData);
                $.ajax({
                    type: 'POST',
                    url: '/itemsaveandrec', // replace with the actual URL that handles the form submission
                    data: formData,
                    dataType: 'json',
                    success: function(res) {
                        //console.log(res.data);
                        $('#itemAddModel').modal('hide');
                        var id = res.data.ItemID;
                        var name = res.data.ItemName;
                        var price = res.data.ItemCostPrice;

                        // create a new row in the table and populate it with the data
                        var newRow1 = $("<tr>");
                        newRow1.append($("<td>").text(id));
                        newRow1.append($("<td>").html('<a href="#" class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#newitemserialized" id="itemName" >'+name+'</a>'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="1" class="serial" id="serial">'));
                        newRow1.append($("<td>").html('<input type="date" class="expDate" id="rexpDate">'));
                        newRow1.append($("<td>").html('<input type="date" class="manDate" id="rmanDate">'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="price" id="pricenew">'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="sellprice" id="sellpricenew">'));
                        newRow1.append($("<td>").html('<input type="text" style="width:35px" value="1"  class="quantity" id="qtynew">'));
                        newRow1.append($("<td>").html('<input type="text" class="discount" style="width:35px" id="discnew">'));
                        newRow1.append($("<td>").html('<input type="hidden" id="rnewamountid" class="ramount">'));
                        newRow1.append($("<td>").html('<input type="text" id="totalnewadd" style="width:80px" value="0" class="rtotal">'));
                        newRow1.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0 getIdnewadd" id="'+res.data.ItemID+'" data-value="'+res.data.ItemID+'"><i class="bi bi-check-square-fill"></i></button>'));
                        newRow1.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+res.data.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'));              

                        var newRow2 = $("<tr>");
                        newRow2.append($("<td>").text(id));
                        newRow2.append($("<td>").text(name));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="0" class="serial" id="serial">'));
                        newRow2.append($("<td>").html('<input type="date" class="expDate" id="rexpDate">'));
                        newRow2.append($("<td>").html('<input type="date" class="manDate" id="rmanDate">'));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="price" id="pricenew">'));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="0.00" class="sellprice" id="sellpricenew">'));
                        newRow2.append($("<td>").html('<input type="text" style="width:35px" value="1" class="quantity" id="qtynew">'));
                        newRow2.append($("<td>").html('<input type="text" class="discount" style="width:35px" id="discnew">'));
                        newRow2.append($("<td>").html('<input type="hidden" id="rnewamountid" class="ramount">'));
                        newRow2.append($("<td>").html('<input type="text" id="totalnewadd" style="width:80px" value="0" class="rtotal">'));
                        newRow2.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0 getIdnewadd" id="'+res.data.ItemID+'" data-value="'+res.data.ItemID+'"><i class="bi bi-check-square-fill"></i></button>'));
                        newRow2.append($("<td>").html('<button class="btn linear-bg text-secondary px-2 py-0" data-id="'+res.data.ItemID+'" id="recDel"><i class="bi bi-trash3-fill"></i></button>'));
                    
                        // // append the new row to the table
                        if(res.data.ItemIsSerialized==1){
                            $("#viewtable").append(newRow1);  
                        }else{
                            $("#viewtable").append(newRow2);
                        }                   
                        
                        $('.getIdnewadd').click(function(e){
                            e.preventDefault();
                            var id = $(this).attr('id');
                            // console.log(id);
                            var total=0;
                            var price = $("#pricenew").val();
                            var qty = $("#qtynew").val();
                            var disc = $(this).closest('tr').find('#discnew').val();

                            var ramount=price*qty;
                            $(this).closest('tr').find('.ramount').val(ramount);

                            if(qty>=1){                                
                                // alert(total);
                                if( disc){
                                    var total= price*qty;
                                    var disc=(total*disc)/100;
                                    var totalwithdisc=total-disc;
                                    total=totalwithdisc;
                                    // alert('qty+disc'+total);
                                }else{
                                    var total= price*qty;
                                    //   alert('no disc, have qty'+total);
                                }
                                // alert(total);                                    
                            }else{
                                if(disc){                                            
                                    var disc=(price*disc)/100;
                                    var totalwithdisc=price-disc;
                                    total=totalwithdisc;
                                    // alert('no qty have disc'+total);
                                }else{
                                    var total= price;
                                    //  alert('no qty no disc'+total);
                                }                                
                                //alert(total);
                            }
                            //console.log(total);                              
                            var val= $(this).closest('tr').find('#totalnewadd').val(total);
                                        
                            var sum = 0;
                            var ramount=0;                                                
                            $(".rtotal").each(function(){
                                sum += parseInt($(this).closest("tr").find(".rtotal").val());
                                //console.log(sum);
                                $("#subtot").val(sum);
                                var netTax= parseInt($("#stax1").val())+parseInt($("#stax2").val());
                                var tot=parseInt($("#subtot").val())-netTax;
                                //console.log(tot); 
                                $("#tot").val(tot);
                            });

                            $(".ramount").each(function(){
                                ramount += parseInt($(this).closest("tr").find(".ramount").val());
                                $("#ramount").val(ramount);
                            });
                        });                             
                    },
                    error: function(jqXHR, textStatus, errorThrown) {
                        //console.log(textStatus, errorThrown);
                    }
                });  
                $("form").trigger("reset");             
            }); 
        });
    </script>
<?php $this->endSection() ?>