<?php $this->extend('layouts\master') ?>
<?php $this->section('terminal') ?>
        <!---List: Start --->
        <div class="container-fluid mt-3 list-of-customer">
            <div class="row p-2">
                <div class="col-12">
                    <div class="row">
                        <div class="container-fluid bg-third rounded-15 p-2 pt-1 bill-area text-center">
                            <div class="d-flex bd-highlight">
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight ms-4 py-0 text-primary fw-bold">
                                                <button class="btn linear-bg text-secondary px-2 py-0" type="button">
                                                    <i class="bi bi-envelope-fill"></i>
                                                </button>
                                            </div>
                                            <div class="flex-fill bd-highlight ms-4 me-2 py-0 text-primary fw-bold">
                                                <div class="searchbar linear-bg">
                                                    <input class="search_input" type="text" name="" placeholder="Search..." id="vtSearch">
                                                    <a href="#" class="search_icon mt-1"><i class="bi bi-search"></i></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="flex-fill bd-highlight">
                                    <div class="subtitle-line bg-secondary ml-1 mt-2 mb-1 ms-auto">
                                        <div class="d-flex bd-highlight">
                                            <div class="flex-fill bd-highlight">New Terminal</div>
                                            <div class="flex-fill bd-highlight">
                                                <div class="ms-2 py-0 text-primary fw-bold">
                                                    <button class="btn linear-bg text-secondary px-2 py-0" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal">
                                                        <i class="bi bi-plus-lg fw-bold"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="rounded-15 bg-secondary p-2 pt-0 mt-2 table-responsive bill-table ">
                                <div class="tableFixHead mt-2">
                                    <input hidden type="text" id="has_errors" name="has_errors" value="<?php echo $has_errors ;?>">
                                    <table class="table rounded align-middle rounded" id="viewtable">
                                        <thead class=" text-center text-secondary rounded">
                                            <th class="p-2" scope="col">ID</th>
                                            <th class="p-2" scope="col">POS ID</th>
                                            <th class="p-2" scope="col">Tenant ID</th>
                                            <th class="p-2" scope="col">Stall No</th>
                                            <th class="p-2" scope="col">Location</th>
                                            <th class="p-2 rounded-end" scope="col">Actions</th>
                                        </thead>
                                        <tbody class="text-primary text-center fw-bold">                                                                                       
                                            <?php 
                                                if($sources):
                                                foreach($sources as $source): 
                                                foreach($source as $s): 
                                            ?>
                                            <tr id="<?php echo $s['id']; ?>">     
                                                <td><?php echo $s['id']; ?></td>
                                                <td><?php echo $s['pos_id']; ?></td>
                                                <td><?php echo $s['tenant_id']; ?></td>
                                                <td><?php echo $s['stall_no']; ?></td>
                                                <td><?php echo $s['location']; ?></td>
                                                <td>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="edit" type="button" data-bs-toggle="modal" data-bs-target="#submit_modal" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-pen-fill"></i>
                                                    </button>
                                                    <button class="btn linear-bg text-secondary px-2 py-0" id="delete" type="button" data-id="<?php echo $s['id']; ?>">
                                                        <i class="bi bi-trash3-fill"></i>
                                                    </button>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                                endforeach;
                                                endif;
                                            ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--- List: End --->
        <!--- Insert/update: Start --->
        <div class="modal fade" id="submit_modal" tabindex="-1" aria-labelledby="userdteModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header linear-bg">
                        <h5 class="modal-title subtitle-line bg-secondary" id="userdteModalLabel">Add New Terminal</h5>
                        <button type="button" class="btn-close bg-secondary" data-bs-dismiss="modal"
                            aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <form method="post" id="add" name="add" action="<?= site_url('/submit-terminal') ?>">
                            <input type="hidden" class="form-control" name="id" id="id" placeholder="ID">
                            <div class="row">
                                <div class="mb-3 col">
                                    <label for="pos_id" class="col-form-label">POS ID:</label>
                                    <input type="text" class="form-control" name="pos_id" id="pos_id" placeholder="Enter POS IP address" value="<?php echo set_value('pos_id');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'pos_id') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="tenant_id" class="col-form-label">Tenant ID:</label>
                                    <select class="form-control" name="tenant_id" id="tenant_id" value="<?php echo set_value('tenant_id');?>">
                                        <option value="0">--Select Tenant ID--</option>
                                        <?php foreach($tenants as $tenant){?>
                                            <option value="<?php echo $tenant['TID'] ;?>" <?php echo set_select('tenant_id',$tenant['TID']);?>><?php echo $tenant['TName'];?></option>"
                                        <?php }?>
                                    </select>
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'tenant_id') : '' ?></h6>
                                </div>
                            </div>
                            <div class="row">                                
                                <div class="mb-3 col">
                                    <label for="stall_no" class="col-form-label">Stall No:</label>
                                    <input type="text" class="form-control" name="stall_no" id="stall_no" placeholder="Enter Stall Number" value="<?php echo set_value('stall_no');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'stall_no') : '' ?></h6>
                                </div>
                                <div class="mb-3 col">
                                    <label for="location" class="col-form-label">Location:</label>
                                    <input type="text" class="form-control" name="location" id="location" placeholder="Enter Location" value="<?php echo set_value('location');?>">
                                    <!-- Error Message-->
                                    <h6 class="text-danger"><?= isset($validation) ? display_error($validation, 'location') : '' ?></h6>
                                </div>
                            </div>                 
                            <div class="row">
                                <div class="mb-3 col">
                                    <button type="submit" class="btn linear-bg text-secondary px-2 py-2 fw-bold">Submit</button>
                                </div>                            
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!--- Insert/update: End --->
    </section>
    <?php echo view('includes/footer'); ?>
    <script>
        function openSubmitModal(){
            var submit_modal = $("#submit_modal");
            var has_errors = $("#has_errors").val();
            if(has_errors == 'true'){
                submit_modal.modal('show');
            }
        }
        jQuery(document).ready(function() {
            openSubmitModal();
            $('#viewtable').DataTable( {
                dom: 'Bfrtip',
                buttons: [
                    { extend: 'csv', className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'excel',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'pdf',  className: 'btn linear-bg text-secondary px-2 py-0' },
                    { extend: 'print', className: 'btn linear-bg text-secondary px-2 py-0' }
                ],                        
                info: false,
                select: {
                    style:    'multi',
                    selector: 'td:first-child'
                },                        
                columnDefs: [ {
                    orderable: false,
                    className: 'select-checkbox',
                    targets:   0
                } ],
            });  
        }); 
        //update
        $('body').on('click', '#edit', function () {
            var id = $(this).attr('data-id');
            $.ajax({
                url: 'terminal/edit/'+id,
                type: "GET",
                dataType: 'json',
                success: function (res) {
                    $('#submit_modal').modal('show');
                    $('#submit_modal #id').val(res.data.id); 
                    $('#submit_modal #pos_id').val(res.data.pos_id); 
                    $('#submit_modal #tenant_id').val(res.data.tenant_id);
                    $('#submit_modal #stall_no').val(res.data.stall_no);
                    $('#submit_modal #location').val(res.data.location);
                },
                    error: function (data) {
                }
            });
        });
        //delete
        $('body').on('click', '#delete', function () {
            var id = $(this).attr('data-id');
            $.get('terminal/delete/'+id, function (data) {
                $('#viewtable tbody #'+ id).remove();
            })
        });  
        //reset form
        $('#submit_modal').on('hidden.bs.modal', function (e) {
            $(this).find('form').trigger('reset');
            $(this).find('.text-danger').remove();
        });
    </script>
<?php $this->endSection() ?>